//
//  MCSocketIOChannel.h
//  MCNetComm
//
//  Created by Brent Gulanowski on 22/04/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <MCNetComm/MCIOChannel.h>

@class AsyncSocket;


@interface MCSocketIOChannel : MCIOChannel {

	AsyncSocket *socket;
	
	// socket is created lazily or upon explicit request
	NSString *address;
	unsigned short port;
	
	BOOL useStreamSSL;
    
    BOOL serverIsHosted;
}

@property BOOL serverIsHosted;

- (AsyncSocket *)socket;
- (void)setSocket:(AsyncSocket *)aSocket;
- (NSString *)address;
- (void)setAddress:(NSString *)anAddress;
- (unsigned short)port;
- (void)setPort:(unsigned short)aPort;

- (BOOL)useStreamSSL;
- (void)setUseStreamSSL:(BOOL)flag;

// -initWithDelegate: is still the designated initializer
- (id)initWithHostAddress:(NSString *)hostAddress port:(unsigned short)hostPort delegate:(id)object;

- (BOOL)openWithHostAddress:(NSString *)hostAddress port:(unsigned short)hostPort;

@end

@interface NSObject (MCSocketIOChannelDelegate)

- (void)onChannel:(MCSocketIOChannel *)aChannel didAccept:(MCSocketIOChannel *)newChannel;

@end
